float Y_2_linCV( float Y, float Ymax, float Ymin) {
     return (Y - Ymin) / (Ymax - Ymin);
}

vec3 darkSurround_to_dimSurround(vec3 linearCV, float gamma){
     vec3 XYZ = linearCV * AP1_2_XYZ_MAT; 

     vec3 xyY = XYZ_2_xyY(XYZ);

          xyY.b = saturate(xyY.b);
          xyY.b = pow(xyY.b, 1.0 / gamma);

          XYZ = xyY_2_XYZ(xyY);

     return XYZ * XYZ_2_AP1_MAT;
}

float bt1886_r(float L, float gamma, float Lw, float Lb){
    float a = pow(pow(Lw, 1 / gamma) - pow(Lb, 1 / gamma), gamma);
    float b = pow(Lb, 1 / gamma) / (pow(Lw, 1 / gamma) - pow(Lb, 1 / gamma));
    float V = pow(max(L / a, 0), 1 / gamma) - b;

    return V;
}

vec3 odt(aces_settings aces, vec3 color){
     color = color * AP0_2_AP1_MAT;

     vec3 rgbPost;

          rgbPost.r = segmented_spline_c9_fwd(color.r);
          rgbPost.g = segmented_spline_c9_fwd(color.g);
          rgbPost.b = segmented_spline_c9_fwd(color.b);

     vec3 linearCV;

          linearCV.r = Y_2_linCV(rgbPost.r, aces.odt_cinema_white, aces.odt_cinema_black);
          linearCV.g = Y_2_linCV(rgbPost.g, aces.odt_cinema_white, aces.odt_cinema_black);
          linearCV.b = Y_2_linCV(rgbPost.b, aces.odt_cinema_white, aces.odt_cinema_black);

     linearCV = darkSurround_to_dimSurround(linearCV, aces.odt_dim_surround_gamma);
     linearCV = linearCV * calc_sat_adjust_matrix(aces.odt_sat_factor, AP1_RGB2Y);

     vec3 xyz = linearCV * AP1_2_XYZ_MAT;
          xyz = xyz * D60_2_D65_CAT;

     linearCV = xyz * XYZ_2_REC709_PRI_MAT;
     linearCV = saturate(linearCV);

     vec3 outputCV;

          outputCV.r = bt1886_r(linearCV.r, aces.odt_dispgamma, aces.odt_l_w, aces.odt_l_b);
          outputCV.g = bt1886_r(linearCV.g, aces.odt_dispgamma, aces.odt_l_w, aces.odt_l_b);
          outputCV.b = bt1886_r(linearCV.b, aces.odt_dispgamma, aces.odt_l_w, aces.odt_l_b);
     
     return outputCV;
     //return linear_to_srgb(linearCV);
}